import javax.swing.*;
import java.awt.event.*;

public class Aplikacja extends JFrame implements ActionListener {
  JComboBox cmb = new JComboBox();
  //w Java 1.5 i wyszych lepiej tak:
  //JComboBox<String> cmb = new JComboBox<String>();
  //w Java 1.7 i wyszych mona te tak:
  //JComboBox<String> cmb = new JComboBox<>();
  public Aplikacja() {
    super();
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setSize(320, 200);
    setTitle("Moja aplikacja w Javie");
    setLayout(null);
        
    cmb.setBounds (80, 40, 170, 20);
    cmb.addItem("Java. wiczenia zaawansowane");
    cmb.addItem("Praktyczny kurs Java");
    cmb.addItem("Java. Leksykon kieszonkowy");
    cmb.addItem("Tablice informatyczne. Java");
    cmb.addActionListener(this);
    
    add(cmb);
    setVisible(true);
  }
  public void actionPerformed(ActionEvent e) {
    String tekst = cmb.getSelectedItem().toString();
    //lub tak:
    //String tekst = cmb.getItemAt(cmb.getSelectedIndex()).toString();
    //w przypadku skorzystania z typw uoglnionych rwnie tak:
    //String tekst = cmb.getItemAt(cmb.getSelectedIndex());
    JOptionPane.showMessageDialog(this, "Wybrany element: " + 
      tekst, "Informacja!", JOptionPane.INFORMATION_MESSAGE);
  }
  public static void main(String args[]) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new Aplikacja();
      }
    });
  }
}
